﻿using System;
using System.Windows;
using System.Windows.Controls;
using AlbumsCatalog.HelloWorldServiceReference;
using AlbumsCatalog.Web;

namespace AlbumsCatalog
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();

            Loaded += new RoutedEventHandler(MainPage_Loaded);
        }

        // Abschluss des Ladevorgangs dieser Ansicht...
        void MainPage_Loaded(object sender, RoutedEventArgs e)
        {
            // Erzeuge client zur Kommunikation
            HelloWorldServiceClient client = new HelloWorldServiceClient();
            // Registriere Completed-Ereignis
            client.HelloWorldCompleted +=
                new EventHandler<HelloWorldCompletedEventArgs>(client_HelloWorldCompleted);
            // Rufe die entfernte Methode HelloWorld asynchron auf
            client.HelloWorldAsync();
        }

        void client_HelloWorldCompleted(object sender, HelloWorldCompletedEventArgs e)
        {
            // Gebe das Ergebnis aus
            MessageBox.Show(Core.VERSION);
        }
    }
}
